/*
Copyright (c) 2009 David Bucciarelli (davibu@interfree.it)

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <cstdio>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <string>
#include <sstream>
#include <stdexcept>

#include "displayfunc.h"
#include "path.h"

using namespace std;

// ./smallluxGPU 1 640 480 scenes/luxball.scn
//   Rays/sec 1460K
int main(int argc, char *argv[]) {
	try {
		cerr << "Usage: " << argv[0] << endl;
		cerr << "Usage: " << argv[0] << " <use CPU/GPU device (0 or 1)> <window width> <window height> <scene file>" << endl;

		if (argc == 5)
			config = new RenderingConfig(argv[4], atoi(argv[2]), atoi(argv[3]), atoi(argv[1]));
		else if (argc == 1)
			config = new RenderingConfig("scenes/simple.scn", 640, 480, true);
		else
			exit(-1);

		InitGlut(argc, argv);
		glutMainLoop();
	} catch (cl::Error err) {
		cerr << "ERROR: " << err.what() << "(" << err.err() << ")" << endl;
	}

	return EXIT_SUCCESS;
}
