/***************************************************************************
 *   Copyright (C) 1998-2009 by David Bucciarelli (davibu@interfree.it)    *
 *                                                                         *
 *   This file is part of SmallLuxGPU.                                     *
 *                                                                         *
 *   SmallLuxGPU is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  SmallLuxGPU is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 *                                                                         *
 *   This project is based on PBRT ; see http://www.pbrt.org               *
 *   and Lux Renderer website : http://www.luxrender.net                   *
 ***************************************************************************/

#ifndef _SCENE_H
#define	_SCENE_H

#include <string>
#include <iostream>
#include <fstream>

#include "point.h"
#include "normal.h"
#include "spectrum.h"
#include "camera.h"
#include "triangle.h"
#include "bvhaccel.h"
#include "ray.h"
#include "mesh.h"

using namespace std;

class Scene {
public:
	Scene(const string &fileName, const unsigned int screenWidth,
		const unsigned int screenHight);
	~Scene() {
		delete sampler;
		delete camera;
		delete mesh;
		delete bvh;
	}

	bool Intersect(const Ray &ray, float *t, unsigned int *index) const {
		*t = INFINITY;
		return bvh->Intersect(ray, t, index);
	}

	unsigned int SampleLights(const float u) const {
		// One Uniform light strategy
		const unsigned int nLights = mesh->triangleCount - meshLightOffset;
		const unsigned int lightIndex = min(Floor2UInt(nLights * u),
				nLights - 1);

		return meshLightOffset + lightIndex;
	}

	bool IsLight(const unsigned int index) const {
		return (index >= meshLightOffset);
	}

	Sampler *sampler;
	PerspectiveCamera *camera;

	unsigned int meshLightOffset;
	TriangleMesh *mesh;

	BVHAccel *bvh;
};

#endif	/* _SCENE_H */
