/***************************************************************************
 *   Copyright (C) 1998-2009 by David Bucciarelli (davibu@interfree.it)    *
 *                                                                         *
 *   This file is part of SmallLuxGPU.                                     *
 *                                                                         *
 *   SmallLuxGPU is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  SmallLuxGPU is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 *                                                                         *
 *   This project is based on PBRT ; see http://www.pbrt.org               *
 *   and Lux Renderer website : http://www.luxrender.net                   *
 ***************************************************************************/

#ifndef _RENDERCONFIG_H
#define	_RENDERCONFIG_H

#include "sampler.h"
#include "scene.h"
#include "film.h"
#include "raybuffer.h"
#include "path.h"

class RenderingConfig {
public:
	RenderingConfig(const string &sceneFileName, const unsigned int w,
		const unsigned int h, const bool useGPU) : minScreenRefreshInterval(0.1),
		maxPathDepth(5), acceleratorType(OPENCL_BVH) {
		rayBuffer = new RayBuffer();
		scene = new Scene(sceneFileName, w, h);
		rayBuffer->currentFreeRay = 0;

		pathIntegrator = new PathIntegrator(scene, rayBuffer, useGPU);
	}

	~RenderingConfig() {
		delete pathIntegrator;
		delete scene;
		delete rayBuffer;
	}

	char captionBuffer0[512];
	char captionBuffer1[512];

	double minScreenRefreshInterval;
	unsigned int maxPathDepth;

	Scene *scene;
	PathIntegrator *pathIntegrator;
	RayBuffer *rayBuffer;

	AccelleratorType acceleratorType;
};

#endif	/* _RENDERCONFIG_H */
